<?php
/**
 * Copyright 2022-2023 FOSSBilling
 * Copyright 2011-2021 BoxBilling, Inc.
 * SPDX-License-Identifier: Apache-2.0.
 *
 * @copyright FOSSBilling (https://www.fossbilling.org)
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache-2.0
 */

namespace Box\Mod\Servicedownloadable\Api;

/**
 * Downloadable service management.
 */
class Client extends \Api_Abstract
{
    /**
     * Use GET to call this method. Sends file attached to order.
     * Sends file as attachment.
     *
     * @return bool
     */
    public function send_file($data)
    {
        if (!isset($data['order_id'])) {
            throw new \FOSSBilling\Exception('Order id is required');
        }
        $identity = $this->getIdentity();
        $order = $this->di['db']->findOne('ClientOrder', 'id = :id AND client_id = :client_id', [':id' => $data['order_id'], ':client_id' => $identity->id]);
        if (!$order instanceof \Model_ClientOrder) {
            throw new \FOSSBilling\Exception('Order not found');
        }

        $orderService = $this->di['mod_service']('order');
        $s = $orderService->getOrderService($order);
        if (!$s instanceof \Model_ServiceDownloadable || $order->status !== 'active') {
            throw new \FOSSBilling\Exception('Order is not activated');
        }

        $service = $this->getService();

        return (bool) $service->sendFile($s);
    }
}
