<?php

namespace modules\billmanagervps\controllers\front;

use email\Email;
use front\FrontController;
use front\ModuleFrontController;
use model\Bill;
use model\Client;
use modules\billmanagervps\classes\BillManagerAPI;
use modules\billmanagervps\classes\model\Order;
use modules\billmanagervps\classes\model\Plan;
use System\Config;
use System\Cookie;
use System\Router;
use System\Tools;
use sms\SMS;

class OrderController extends ModuleFrontController  {
    public function actionList()
    {
        parent::actionList(); // TODO: Change the autogenerated stub
    }

    public function actionListAjax(){

        $orderObject = Order::factory();


        $view = $this->getModuleView('order/list.php');

        $orderObject
            ->select('*')
            ->select(Plan::factory(), 'name')

            ->join(Plan::factory(), 'plan_id', 'id')

            ->where('client_id', $this->client->id)
        ->limit($this->from, $this->count);



        $filter  = Tools::rPOST('filter');
        $vfilter = array();
        if (isset($filter) && $filter != '') {
            foreach ($filter as $field => $option) {

                $value = $option['value'];
                $type  = isset($option['type']) ? $option['type'] : 'like';
                $vfilter[$field] = $value;

                if ($field && $value != '') {
                    if ($type == 'like') {
                        $orderObject->where($field, 'LIKE', '%' . $value . '%');
                    } else if ($type == 'equal') {
                        $orderObject->where($field, $value);
                    }
                }
            }
        }

        $order = Tools::rPOST('order');

        if ($order['field']) {
            $orderObject->order($order['field'], $order['type']);
        } else {
            $orderObject->order('id', 'desc');
        }

        $view->filter = $vfilter;

        $orders = $orderObject->getRows();
        $view->orders     = $orders;

        $view->plans = Plan::factory()->getRows();

        $all              = $orderObject->lastQuery()->getRowsCount();
        $view->pagination = $this->pagination($all);

        $view->currency = $this->currency;

        $this->layout->import('content', $view);
    }

    public function actionNew(){
        $planObject = new Plan();
        $view = $this->getModuleView('order/new.php');
        $this->layout->import('content', $view);


        $view->plans = $planObject->getRows();

    }

    public function actionPlan(){
        $planObject = new Plan(Router::getParam(0));

        if(Tools::rPOST()){

            $planObject = new Plan(Tools::rPOST('id_plan'));
            $pay_period = Tools::rPOST('pay_period');
            $domain = Tools::rPOST('domain');

            $total = $planObject->price* $pay_period;

            $orderObject = new Order();
            $orderObject->plan_id = $planObject->id;
            $orderObject->ostempl = Tools::rPOST('template');
            $orderObject->client_id = $this->client->id;
            $orderObject->paid_to = date('Y-m-d');
            $orderObject->domain = Tools::rPOST('domain');
            $orderObject->save();


            $billObject= new Bill();

            $billObject->client_id          = $this->client->id;
            $billObject->hosting_account_id = $orderObject->id;
            $billObject->hosting_plan_id    = $planObject->id;
            $billObject->price              = $planObject->price;
            $billObject->pay_period         = $pay_period;
            $billObject->total              = $total;
            $billObject->date               = date('Y-m-d');
            $billObject->type               = 101;


            if ($billObject->save()) {
                Tools::redirect('bill/'.$billObject->id);
            }



        }

        $view = $this->getModuleView('order/plan.php');
        $this->layout->import('content', $view);
        $view->plan = $planObject;
        $templates = $planObject->templates;
        $templates = explode(PHP_EOL, $templates);
        $templates_formed = array();
        foreach ($templates as $template){
            $res = explode('=', $template);
            $templates_formed[$res[0]] = $res[1];
        }


        $view->templates = $templates_formed;

    }

    public function actionInfoAjax(){
        $view = $this->getModuleView('order/info.php');


        $orderObject = new Order(Tools::rGET('id_order'));

        if($orderObject->client_id != $this->client->id){
            Tools::display403Error();
        }



        $view->order = $orderObject;
        $view->plan = new Plan($orderObject->plan_id);

        $this->carcase->import('content', $view);
    }


    
    
    public function actionProlong(){
        $order    = new Order(Tools::rGET('id_order'));

        $v = $this->getModuleView('order/prolong.php');

        $v->error       = array();
        $plan           = new Plan($order->plan_id);
        $v->plan        = $plan;
        $v->order       = $order;

        $v->username    = $order->username;

        $this->layout->import('content', $v);

        $hb    = new Bill();
        $bills = $hb->where('hosting_account_id', $order->id)->where('type', 101)->where('is_paid', 0)->getRow();
        if ($bills) {
            $v->error = ('bill_exist');
        }

        if ($order->isLoadedObject() && Tools::rPOST('pay_period')) {

            if(!in_array(Tools::rPOST('pay_period'), array(1,3,6,12))){
                Tools::display404Error();
            }

            if ($bills) {
                $v->error = ('bill_exist');
            } else {
                $total = Tools::rPOST('pay_period') * $plan->price;

                $bill                     = new Bill();
                $bill->client_id          = $this->client->id;
                $bill->hosting_account_id = $order->id;
                $bill->hosting_plan_id    = $plan->id;
                $bill->price              = $plan->price;
                $bill->pay_period         = Tools::rPOST('pay_period');
                $bill->total              = $total;
                $bill->date               = date('Y-m-d');
                $bill->type               = 101;

                //  print_r($bill);exit();
                if ($bill->save()) {
                    Tools::redirect('/bill/' . $bill->id);
                }
            }
        }
    }

}